/*
 * Decompiled with CFR 0.152.
 */
package vstrade.moduls.cargo;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import vstrade.Program;
import vstrade.data.Node;
import vstrade.data.bases.Base;
import vstrade.data.bases.Cargo;
import vstrade.io.Log;
import vstrade.shared.ComboSelectionManager;
import vstrade.shared.GUIFactory;
import vstrade.shared.ModuleView;

public class CargoView
extends ModuleView
implements ActionListener {
    private final String ACTION_CARGO_SELECTED = "InfoCargo";
    private JComboBox jCargo;
    private JPanel jCargoTPanel;
    private JLabel jImage;
    private JPanel jImageTPanel;
    private JLabel jCargoPath;
    private JPanel jCargoPathTPanel;
    private JTextPane jDescription;
    private JPanel jDescriptionTPanel;
    private String sImage;
    private String sStandardPrice;
    private String sDescription;
    private Program program;

    public CargoView(Program program) {
        this.program = program;
        this.jCargo = GUIFactory.jComboBox(this, "InfoCargo");
        this.jCargo.setKeySelectionManager(new ComboSelectionManager());
        this.jCargoTPanel = GUIFactory.jPTitle(this.jCargo);
        JPanel cargoPanel = GUIFactory.jPRow(this.jCargoTPanel);
        this.jImage = new JLabel();
        this.jImage.setPreferredSize(new Dimension(250, 175));
        this.jImage.setMinimumSize(new Dimension(250, 175));
        this.jImage.setMaximumSize(new Dimension(250, 175));
        this.jImage.setHorizontalAlignment(0);
        this.jImage.setVerticalAlignment(0);
        this.jImageTPanel = GUIFactory.jPTitle(this.jImage);
        JPanel jImageRPanel = GUIFactory.jPRow(this.jImageTPanel);
        this.jCargoPath = new JLabel();
        this.jCargoPath.setMinimumSize(new Dimension(515, 25));
        this.jCargoPath.setPreferredSize(new Dimension(780, 25));
        this.jCargoPath.setMaximumSize(new Dimension(780, 25));
        this.jCargoPathTPanel = GUIFactory.jPTitle(this.jCargoPath);
        JPanel jCargoPathRPanel = GUIFactory.jPRow(this.jCargoPathTPanel);
        this.jDescription = new JTextPane();
        this.jDescription.setBorder(BorderFactory.createEmptyBorder(0, 10, 0, 10));
        this.jDescription.setEditable(false);
        this.jDescription.setEnabled(false);
        this.jDescription.setDisabledTextColor(Color.BLACK);
        this.jDescription.setContentType("text/html");
        this.jDescription.setBackground(null);
        JScrollPane jDescriptionSPanel = new JScrollPane(this.jDescription);
        jDescriptionSPanel.setBorder(null);
        jDescriptionSPanel.setViewportView(this.jDescription);
        jDescriptionSPanel.setPreferredSize(new Dimension(780, Short.MAX_VALUE));
        jDescriptionSPanel.setMaximumSize(new Dimension(780, Short.MAX_VALUE));
        this.jDescriptionTPanel = GUIFactory.jPTitle(jDescriptionSPanel);
        JPanel jDescriptionPanel = new JPanel();
        jDescriptionPanel.setLayout(new BoxLayout(jDescriptionPanel, 2));
        jDescriptionPanel.setPreferredSize(new Dimension(Short.MAX_VALUE, Short.MAX_VALUE));
        jDescriptionPanel.setMaximumSize(new Dimension(Short.MAX_VALUE, Short.MAX_VALUE));
        jDescriptionPanel.add(this.jDescriptionTPanel);
        JPanel panel = new JPanel();
        panel.add(cargoPanel);
        panel.add(jImageRPanel);
        panel.add(jCargoPathRPanel);
        panel.add(jDescriptionPanel);
        panel.setLayout(new BoxLayout(panel, 3));
        this.setLayout(new BoxLayout(this, 3));
        this.add(panel);
    }

    @Override
    public void setData() {
        this.updateLanguage();
        boolean bEnabled = this.program.getBases().isLoaded();
        if (bEnabled) {
            this.jCargo.setModel(new DefaultComboBoxModel<Node>(this.program.getBases().getCargoList()));
            if (this.jCargo.getItemCount() > 0) {
                this.jCargo.setSelectedIndex(0);
            }
        }
        this.jCargo.setEnabled(bEnabled);
    }

    @Override
    public void clearData() {
        String[] arrCargo = new String[]{this.program.getSettings().getLanguageSettings().getString("NoCargo", "cargo")};
        this.jCargo.setModel(new DefaultComboBoxModel<String>(arrCargo));
    }

    @Override
    public void updateLanguage() {
        this.sTitle = this.program.getSettings().getLanguageSettings().getString("Title", "cargo");
        this.sImage = this.program.getSettings().getLanguageSettings().getString("ImageTT", "cargo");
        this.sStandardPrice = this.program.getSettings().getLanguageSettings().getString("StandardPrice", "cargo");
        this.sDescription = this.program.getSettings().getLanguageSettings().getString("Description", "cargo");
        this.jCargo.setToolTipText(this.program.getSettings().getLanguageSettings().getString("CargoTT", "cargo"));
        GUIFactory.setBorderTitle(this.jCargoTPanel, this.program.getSettings().getLanguageSettings().getString("Cargo", "cargo"));
        GUIFactory.setBorderTitle(this.jImageTPanel, this.program.getSettings().getLanguageSettings().getString("Image", "cargo"));
        GUIFactory.setBorderTitle(this.jCargoPathTPanel, this.program.getSettings().getLanguageSettings().getString("CargoPath", "cargo"));
        GUIFactory.setBorderTitle(this.jDescriptionTPanel, this.program.getSettings().getLanguageSettings().getString("Information", "cargo"));
    }

    public void setSelectedCargo(Cargo cargo) {
        this.jCargo.setSelectedItem(cargo);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if ("InfoCargo".equals(e.getActionCommand())) {
            String sPath = "";
            String sImagePath = "";
            String sInfo = "";
            ImageIcon cargoImage = null;
            Base base = this.program.getBases().getTemplateBase();
            Node cargoNode = (Node)this.jCargo.getSelectedItem();
            sPath = cargoNode.getPath();
            if (cargoNode instanceof Cargo) {
                Cargo cargo = (Cargo)cargoNode;
                sImagePath = this.program.getSettings().getFileSettings().getTexturesPath() + File.separator + cargo.getImagePath();
                File file = new File(sImagePath);
                try {
                    BufferedImage image = ImageIO.read(file);
                    if (image != null) {
                        if (image.getWidth() > 128) {
                            AffineTransform tx = new AffineTransform();
                            double scaleFactor = 128.0 / (double)image.getWidth();
                            tx.scale(scaleFactor, scaleFactor);
                            AffineTransformOp op = new AffineTransformOp(tx, 2);
                            image = op.filter(image, null);
                        }
                        cargoImage = new ImageIcon(image, this.sImage);
                    }
                }
                catch (IOException ex) {
                    Log.info("Cargo not found: " + sImagePath + " " + ex.getMessage());
                }
                sInfo = "<html><b>" + this.sStandardPrice + ": </b>" + cargo.getStandardPrice() + "<br><br><b>" + this.sDescription + ":</b><br>" + cargo.getDescription();
            } else {
                sPath = sPath + "/";
            }
            this.jCargoPath.setText("<html><b>" + sPath + "</b>");
            this.jDescription.setText(sInfo);
            this.jDescription.setCaretPosition(0);
            this.jImage.setIcon(cargoImage);
        }
    }
}

