/*
 * Decompiled with CFR 0.152.
 */
package vstrade.language;

import java.net.URL;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Vector;
import vstrade.io.Log;
import vstrade.language.LocaleItem;

public class ResourceBundleManager {
    private Vector<LocaleItem> supportedLocals;
    private LocaleItem currentLocaleItem;
    private final String sResourceBundlePath = "vstrade/language/";
    private String[] propertyFiles = new String[]{"about", "cargo", "help", "map", "price", "settings", "status", "trade"};

    public ResourceBundleManager() {
        this.supportedLocals = new Vector();
        this.currentLocaleItem = new LocaleItem(new Locale("en", "US"));
        Locale[] locales = Locale.getAvailableLocales();
        for (int i = 0; i < locales.length; ++i) {
            boolean bExist = true;
            for (int b = 0; b < this.propertyFiles.length && (bExist = this.doBundleExist(this.propertyFiles[b], locales[i])); ++b) {
            }
            if (!bExist) continue;
            this.supportedLocals.add(new LocaleItem(locales[i]));
        }
        this.supportedLocals.add(new LocaleItem("Keys", "Keys"));
    }

    public String getString(String sKey, String sBundle) {
        String s;
        ResourceBundle rBundle = ResourceBundle.getBundle("vstrade/language/" + sBundle, new Locale(this.currentLocaleItem.getLanguage(), this.currentLocaleItem.getCountry()));
        if (this.currentLocaleItem.equals(new LocaleItem("Keys", "Keys"))) {
            return "[" + sKey + "]";
        }
        try {
            s = rBundle.getString(sKey);
        }
        catch (Exception e) {
            Log.warning("Translation of \"" + sKey + "\" key is missing from \"" + sBundle + "\" bundle \"" + this.currentLocaleItem.getLanguage() + "\" (" + this.currentLocaleItem.getCountry() + ")");
            s = "[" + sKey + "]";
        }
        return s;
    }

    public Vector<LocaleItem> getLocaleItemList() {
        return this.supportedLocals;
    }

    public LocaleItem getCurrentLocale() {
        return this.currentLocaleItem;
    }

    public void setCurrentLocale(LocaleItem localeItem) {
        if (this.supportedLocals.contains(localeItem)) {
            this.currentLocaleItem = localeItem;
            Log.info("Language: " + this.currentLocaleItem.getLanguage() + " (" + this.currentLocaleItem.getCountry() + ")");
        }
    }

    private boolean doBundleExist(String sName, Locale locale) {
        String sLocal = sName + "_" + locale.getLanguage() + "_" + locale.getCountry() + ".properties";
        URL url = this.getClass().getResource(sLocal);
        return url != null;
    }
}

