/*
 * Decompiled with CFR 0.152.
 */
package vstrade.io;

import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import javax.swing.JOptionPane;

public class Log {
    public static final String FILENAME = "vstrade_log.txt";
    public static FileWriter fileWriter;
    public static boolean bInitialized;

    private Log() {
    }

    public static void write(String s) {
        Log.print(s);
    }

    public static void debug(String s) {
        Log.print("(Debug) " + s);
    }

    public static void error(Throwable e) {
        String s = "An unknown error has occurred!\n\nPlease report this error at:\nhttp://vegastrike.sourceforge.net/forums/viewtopic.php?t=6286\n\nPlease include vstrade_log.txt in your post and a brife explanation of what you were doing at the time of the crash";
        Log.printErrorToScreen(s);
        Log.print("(Error) " + s, true, e);
        System.exit(1);
    }

    public static void error(String s, Throwable e) {
        Log.printErrorToScreen(s);
        Log.print("(Error) " + s, true, e);
        System.exit(1);
    }

    public static void error(String s) {
        Log.printErrorToScreen(s);
        Log.print("(Error) " + s, true, null);
        System.exit(1);
    }

    public static void info(String s) {
        Log.print("(Info) " + s);
    }

    public static void warning(String s) {
        Log.print("(Warning) " + s);
    }

    public static void showWarning(String s) {
        Log.printWarningToScreen(s);
    }

    private static void print(String s) {
        Log.print(s, false, null);
    }

    private static void print(String s, boolean e, Throwable t) {
        if (e) {
            System.err.println(s);
        } else {
            System.out.println(s);
        }
        Log.open();
        try {
            fileWriter.write(s + "\r\n");
        }
        catch (IOException xe) {
            xe.printStackTrace();
        }
        if (t != null) {
            PrintWriter printWriter = new PrintWriter(fileWriter);
            t.printStackTrace(printWriter);
        }
        Log.close();
    }

    private static void printErrorToScreen(String s) {
        JOptionPane.showMessageDialog(null, s, "Error", 0);
    }

    private static void printWarningToScreen(String s) {
        JOptionPane.showMessageDialog(null, s, "Warning", 2);
    }

    private static void init() {
        bInitialized = true;
        try {
            fileWriter = new FileWriter(FILENAME, false);
            fileWriter.write("");
            fileWriter.close();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    private static void open() {
        if (!bInitialized) {
            Log.init();
        }
        try {
            fileWriter = new FileWriter(FILENAME, true);
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    private static void close() {
        try {
            fileWriter.close();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    static {
        bInitialized = false;
    }
}

