/*
 * Decompiled with CFR 0.152.
 */
package vstrade.data.settings;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Vector;
import vstrade.data.settings.Settings;
import vstrade.io.Log;

public class SettingsWriter {
    FileWriter fileWriter;
    Settings settings;

    public void save(Settings settings) {
        this.settings = settings;
        boolean bSucceed = this.openFile(new File(settings.getFileSettings().getSettingsPath()));
        if (bSucceed) {
            this.write();
        }
        if (bSucceed) {
            this.closeFile();
        }
        if (bSucceed) {
            Log.info("Settings saved (vstrade_settings.xml)");
        }
    }

    private boolean write() {
        try {
            this.fileWriter.write("<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?>\r\n");
            this.fileWriter.write("<!-- VSTrade Settings File -->\r\n");
            this.fileWriter.write("<settings>\r\n");
            this.fileWriter.write("\t<vegastrikepath>" + this.settings.getFileSettings().getVegaStrikePath() + "</vegastrikepath>\r\n");
            this.fileWriter.write("\t<autoconfig>" + this.settings.getAutoConfig() + "</autoconfig>\r\n");
            this.fileWriter.write("\t<switchcomponent>" + this.settings.getSwitchComponent() + "</switchcomponent>\r\n");
            this.fileWriter.write("\t<trade>\r\n");
            Vector<String> basesColumns = this.settings.getTradeSettings().getTradeTableColumns();
            for (int a = 0; a < basesColumns.size(); ++a) {
                this.fileWriter.write("\t\t<tradecolumn>" + basesColumns.get(a) + "</tradecolumn>\r\n");
            }
            this.fileWriter.write("\t</trade>\r\n");
            this.fileWriter.write("\t<price>\r\n");
            Vector<String> pricesColumns = this.settings.getPriceSettings().getPriceTableColumns();
            for (int a = 0; a < pricesColumns.size(); ++a) {
                this.fileWriter.write("\t\t<pricecolumn>" + pricesColumns.get(a) + "</pricecolumn>\r\n");
            }
            this.fileWriter.write("\t</price>\r\n");
            this.fileWriter.write("\t<map>\r\n");
            this.fileWriter.write("\t\t<autocenter>" + this.settings.getMapSettings().isAutoCenterEnabled() + "</autocenter>\r\n");
            this.fileWriter.write("\t\t<factions>" + this.settings.getMapSettings().showFactions() + "</factions>\r\n");
            this.fileWriter.write("\t\t<jumplesssystems>" + this.settings.getMapSettings().showJumplessSystems() + "</jumplesssystems>\r\n");
            this.fileWriter.write("\t\t<jumpslines>" + this.settings.getMapSettings().showJumpsLines() + "</jumpslines>\r\n");
            this.fileWriter.write("\t\t<names>" + this.settings.getMapSettings().showNames() + "</names>\r\n");
            this.fileWriter.write("\t\t<sectorboxes>" + this.settings.getMapSettings().showSectorBoxes() + "</sectorboxes>\r\n");
            this.fileWriter.write("\t\t<sectors>" + this.settings.getMapSettings().showSectors() + "</sectors>\r\n");
            this.fileWriter.write("\t\t<yaxis>" + this.settings.getMapSettings().showYaxis() + "</yaxis>\r\n");
            this.fileWriter.write("\t</map>\r\n");
            this.fileWriter.write("\t<locale>\r\n");
            this.fileWriter.write("\t\t<language>" + this.settings.getLanguageSettings().getCurrentLocale().getLanguage() + "</language>\r\n");
            this.fileWriter.write("\t\t<country>" + this.settings.getLanguageSettings().getCurrentLocale().getCountry() + "</country>\r\n");
            this.fileWriter.write("\t</locale>\r\n");
            this.fileWriter.write("</settings>\r\n");
        }
        catch (IOException t) {
            Log.error("Settings not saved (vstrade_settings.xml - WRITE FAILED)", t);
            return false;
        }
        return true;
    }

    private boolean closeFile() {
        try {
            this.fileWriter.close();
        }
        catch (IOException t) {
            Log.error("Settings not saved (vstrade_settings.xml - CLOSE FAILED)", t);
            return false;
        }
        return true;
    }

    private boolean openFile(File filename) {
        try {
            this.fileWriter = new FileWriter(filename);
        }
        catch (IOException t) {
            Log.error("Settings not saved (vstrade_settings.xml - OPEN FAILED)", t);
            return false;
        }
        return true;
    }
}

