/*
 * Decompiled with CFR 0.152.
 */
package vstrade.data.settings;

import java.io.FileInputStream;
import java.io.InputStream;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;
import vstrade.data.settings.Settings;
import vstrade.io.Log;
import vstrade.language.LocaleItem;

public class SettingsReader
extends DefaultHandler {
    Settings settings;
    InputStream file;
    String sChars = "";
    String sLanguage = "";
    String sCountry = "";
    String sVariant = "";

    public boolean load(Settings settings) {
        this.settings = settings;
        settings.getPriceSettings().clearTradeColumns();
        settings.getTradeSettings().clearPriceColumns();
        try {
            this.file = new FileInputStream(settings.getFileSettings().getSettingsPath());
        }
        catch (Throwable t) {
            Log.info("Using default settings (NOT FOUND: \"" + settings.getFileSettings().getSettingsPath() + "\")");
            return false;
        }
        SettingsReader handler = this;
        SAXParserFactory factory = SAXParserFactory.newInstance();
        try {
            SAXParser saxParser = factory.newSAXParser();
            saxParser.parse(this.file, (DefaultHandler)handler);
        }
        catch (Throwable t) {
            t.printStackTrace();
            Log.error("Using default settings (PARSER FAILED \"" + settings.getFileSettings().getSettingsPath() + "\")", t);
        }
        Log.info("Settings loaded");
        return true;
    }

    @Override
    public void startElement(String namespaceURI, String lName, String qName, Attributes attrs) throws SAXException {
        String eName = lName;
        if ("".equals(eName)) {
            eName = qName;
        }
        this.sChars = "";
    }

    @Override
    public void endElement(String namespaceURI, String sName, String qName) throws SAXException {
        String eName = sName;
        if ("".equals(eName)) {
            eName = qName;
        }
        if ("vegastrikepath".equals(eName)) {
            this.settings.getFileSettings().setVegaStrikePath(this.sChars, false);
        }
        if ("autoconfig".equals(eName)) {
            this.settings.setAutoConfig(this.stringToBoolean(this.sChars));
        }
        if ("switchcomponent".equals(eName)) {
            this.settings.setSwitchComponent(this.stringToBoolean(this.sChars));
        }
        if ("tradecolumn".equals(eName)) {
            this.settings.getTradeSettings().addTradeTableColumn(this.sChars);
        }
        if ("pricecolumn".equals(eName)) {
            this.settings.getPriceSettings().addPriceTableColumn(this.sChars);
        }
        if ("autocenter".equals(eName)) {
            this.settings.getMapSettings().enableAutoCenter(this.stringToBoolean(this.sChars));
        }
        if ("factions".equals(eName)) {
            this.settings.getMapSettings().showFactions(this.stringToBoolean(this.sChars));
        }
        if ("jumplesssystems".equals(eName)) {
            this.settings.getMapSettings().showJumplessSystems(this.stringToBoolean(this.sChars));
        }
        if ("jumpslines".equals(eName)) {
            this.settings.getMapSettings().showJumpsLines(this.stringToBoolean(this.sChars));
        }
        if ("names".equals(eName)) {
            this.settings.getMapSettings().showNames(this.stringToBoolean(this.sChars));
        }
        if ("sectorboxes".equals(eName)) {
            this.settings.getMapSettings().showSectorBoxes(this.stringToBoolean(this.sChars));
        }
        if ("sectors".equals(eName)) {
            this.settings.getMapSettings().showSectors(this.stringToBoolean(this.sChars));
        }
        if ("yaxis".equals(eName)) {
            this.settings.getMapSettings().showYaxis(this.stringToBoolean(this.sChars));
        }
        if ("yaxis".equals(eName)) {
            this.settings.getMapSettings().showYaxis(this.stringToBoolean(this.sChars));
        }
        if ("language".equals(eName)) {
            this.sLanguage = this.sChars;
        }
        if ("country".equals(eName)) {
            this.sCountry = this.sChars;
        }
        if ("locale".equals(eName)) {
            this.settings.getLanguageSettings().setCurrentLocale(new LocaleItem(this.sLanguage, this.sCountry));
        }
    }

    @Override
    public void characters(char[] buf, int offset, int len) throws SAXException {
        String sTemp = new String(buf, offset, len);
        this.sChars = this.sChars + sTemp;
    }

    private boolean stringToBoolean(String s) {
        return s.equals("true");
    }
}

