/*
 * Decompiled with CFR 0.152.
 */
package vstrade.data.settings;

import vstrade.data.settings.FileSettings;
import vstrade.data.settings.MapSettings;
import vstrade.data.settings.PriceSettings;
import vstrade.data.settings.SettingsReader;
import vstrade.data.settings.SettingsWriter;
import vstrade.data.settings.TradeSettings;
import vstrade.language.ResourceBundleManager;

public class Settings {
    private FileSettings fileSettings;
    private MapSettings mapSettings;
    private TradeSettings tradeSettings;
    private PriceSettings priceSettings;
    private boolean bDefaultSettings;
    private boolean bAutoConfig;
    private boolean bSwitchComponent;
    private SettingsReader settingsReader = new SettingsReader();
    private SettingsWriter settingsWriter = new SettingsWriter();
    private ResourceBundleManager resourceBundleManager;

    public Settings() {
        this.fileSettings = new FileSettings();
        this.mapSettings = new MapSettings();
        this.tradeSettings = new TradeSettings();
        this.priceSettings = new PriceSettings();
        this.resourceBundleManager = new ResourceBundleManager();
        boolean bl = this.bDefaultSettings = !this.settingsReader.load(this);
        if (this.bDefaultSettings) {
            this.bAutoConfig = true;
            this.bSwitchComponent = true;
            this.mapSettings.showJumpsLines(false);
            this.mapSettings.showJumplessSystems(false);
            this.mapSettings.showNames(true);
            this.mapSettings.showFactions(false);
            this.mapSettings.showSectors(false);
            this.mapSettings.showSectorBoxes(false);
            this.mapSettings.showYaxis(true);
            this.mapSettings.enableAutoCenter(true);
            this.tradeSettings.addTradeTableColumn("TableBuyBase");
            this.tradeSettings.addTradeTableColumn("TableSellBase");
            this.tradeSettings.addTradeTableColumn("TableCommerce");
            this.tradeSettings.addTradeTableColumn("TableAvgQuantity");
            this.tradeSettings.addTradeTableColumn("TableAvgPercent");
            this.tradeSettings.addTradeTableColumn("TableAvgCash");
            this.priceSettings.addPriceTableColumn("TableBase");
            this.priceSettings.addPriceTableColumn("TableCommerce");
            this.priceSettings.addPriceTableColumn("TableAvgQuantity");
            this.priceSettings.addPriceTableColumn("TableMaxPrice");
            this.priceSettings.addPriceTableColumn("TableAvgPrice");
            this.priceSettings.addPriceTableColumn("TableMinPrice");
            this.priceSettings.addPriceTableColumn("TablePercentPrice");
        }
    }

    public FileSettings getFileSettings() {
        return this.fileSettings;
    }

    public MapSettings getMapSettings() {
        return this.mapSettings;
    }

    public TradeSettings getTradeSettings() {
        return this.tradeSettings;
    }

    public PriceSettings getPriceSettings() {
        return this.priceSettings;
    }

    public ResourceBundleManager getLanguageSettings() {
        return this.resourceBundleManager;
    }

    public boolean getAutoConfig() {
        return this.bAutoConfig;
    }

    public void setAutoConfig(boolean bAutoConfig) {
        this.bAutoConfig = bAutoConfig;
    }

    public boolean getSwitchComponent() {
        return this.bSwitchComponent;
    }

    public void setSwitchComponent(boolean bSwitchComponent) {
        this.bSwitchComponent = bSwitchComponent;
    }

    public void saveSettings() {
        this.settingsWriter.save(this);
        this.fileSettings.isVegaStrikePathUpdated(false);
    }
}

