/*
 * Decompiled with CFR 0.152.
 */
package vstrade.data.settings;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import vstrade.data.settings.FileSettings;
import vstrade.data.settings.FileSettingsLoadException;
import vstrade.io.Log;

public class FileSettingsParser {
    private FileSettings files;

    public boolean load(FileSettings files, String filename) {
        this.files = files;
        FileInputStream input = null;
        try {
            input = new FileInputStream(new File(filename));
        }
        catch (Exception ex) {
            Log.error("\"" + filename + "\" is missing from the working directory.\nPlease see vstrade_faq.txt for more information.");
            return false;
        }
        try {
            this.loadMod(input);
        }
        catch (FileSettingsLoadException ex) {
            Log.error("No paths loaded (PARSER ERROR: \"" + filename + "\")", ex);
            return false;
        }
        Log.info("Paths loaded");
        return true;
    }

    private void loadMod(InputStream is) throws FileSettingsLoadException {
        DocumentBuilderFactory factory = null;
        DocumentBuilder builder = null;
        Document doc = null;
        try {
            factory = DocumentBuilderFactory.newInstance();
            builder = factory.newDocumentBuilder();
            doc = builder.parse(is);
            is.close();
        }
        catch (Exception e) {
            throw new FileSettingsLoadException(e);
        }
        Element element = doc.getDocumentElement();
        this.parseMods(element);
    }

    private void parseMods(Element element) throws FileSettingsLoadException {
        if (!element.getNodeName().equals("files")) {
            throw new FileSettingsLoadException("Wrong root element name.");
        }
        NodeList varList = element.getElementsByTagName("var");
        for (int i = 0; i < varList.getLength(); ++i) {
            Element child = (Element)varList.item(i);
            this.parseVar(child);
        }
    }

    private void parseVar(Element element) {
        String sKey = element.getAttribute("key");
        String sValue = element.getAttribute("value");
        if (sKey.equals("") || sValue.equals("")) {
            Log.warning("Ill formed XML (files.xml)");
            return;
        }
        this.addVar(sKey, sValue);
    }

    private void addVar(String sKey, String sValue) {
        this.files.add(sKey, sValue);
    }
}

