/*
 * Decompiled with CFR 0.152.
 */
package vstrade.data.settings;

import java.io.File;
import java.util.Hashtable;
import java.util.Vector;
import vstrade.data.settings.FileSettingsParser;

public class FileSettings {
    public static final String MASTER_PART_LIST = "masterpartlist";
    public static final String UNITS = "units";
    public static final String UNIVERSE = "universe";
    public static final String TEXTURES = "textures";
    public static final String MAP = "map";
    public static final String AUTO = "auto";
    private final String sSettingsPath = System.getProperty("user.dir") + File.separator + "vstrade_settings.xml";
    private final String sReadmePath = System.getProperty("user.dir") + File.separator + "vstrade_readme.txt";
    private final String sFilesPath = System.getProperty("user.dir") + File.separator + "vstrade_files.xml";
    private String sVegaStrikePath = "";
    private boolean bVSPathUpdated = false;
    private Hashtable<String, Vector<String>> keys = new Hashtable();

    public FileSettings() {
        FileSettingsParser pathsParser = new FileSettingsParser();
        pathsParser.load(this, this.sFilesPath);
    }

    public void add(String sKey, String sValue) {
        if (!this.keys.containsKey(sKey)) {
            this.keys.put(sKey, new Vector());
        }
        this.keys.get(sKey).add(sValue);
    }

    public String getVegaStrikePath() {
        return this.sVegaStrikePath;
    }

    public void setVegaStrikePath(String sVegaStrikePath) {
        if (!this.sVegaStrikePath.equals(sVegaStrikePath)) {
            this.bVSPathUpdated = true;
        }
        this.sVegaStrikePath = sVegaStrikePath;
    }

    public void setVegaStrikePath(String sVegaStrikePath, boolean bVSPathUpdated) {
        this.bVSPathUpdated = bVSPathUpdated;
        this.sVegaStrikePath = sVegaStrikePath;
    }

    public String getSettingsPath() {
        return this.sSettingsPath;
    }

    public String getReadmePath() {
        return this.sReadmePath;
    }

    public String getMasterPartListPath() {
        return this.getPath(MASTER_PART_LIST);
    }

    public String getUnitsPath() {
        return this.getPath(UNITS);
    }

    public String getMilkyWayPath() {
        return this.getPath(UNIVERSE);
    }

    public String getTexturesPath() {
        return this.getPath(TEXTURES);
    }

    public boolean isVegaStrikePathUpdated() {
        return this.bVSPathUpdated;
    }

    public void isVegaStrikePathUpdated(boolean bVSPathUpdated) {
        this.bVSPathUpdated = bVSPathUpdated;
    }

    public boolean isVegaStrikePathVaild() {
        return this.isValidPath(this.sVegaStrikePath);
    }

    public boolean isValidPath(String sNewVegaStrikePath) {
        if (sNewVegaStrikePath == null) {
            return false;
        }
        boolean bFound = this.isPathValid(UNIVERSE, sNewVegaStrikePath);
        if (bFound) {
            bFound = this.isPathValid(UNITS, sNewVegaStrikePath);
        }
        if (bFound) {
            bFound = this.isPathValid(MASTER_PART_LIST, sNewVegaStrikePath);
        }
        return bFound;
    }

    private boolean isPathValid(String sKey, String sNewVegaStrikePath) {
        return !this.getPath(sKey, sNewVegaStrikePath).equals("");
    }

    public String getPath(String sKey) {
        return this.getPath(sKey, this.sVegaStrikePath);
    }

    public String getPath(String sKey, String sCurrentVegaStrikePath) {
        if ((sCurrentVegaStrikePath = sCurrentVegaStrikePath.replace("/", File.separator).replace("\\", File.separator)).lastIndexOf(File.separator) < sCurrentVegaStrikePath.length() - 1) {
            sCurrentVegaStrikePath = sCurrentVegaStrikePath + File.separator;
        }
        Vector<String> paths = this.keys.get(sKey);
        File file = new File("");
        if (paths != null) {
            for (int i = 0; i < paths.size(); ++i) {
                String sPath = sCurrentVegaStrikePath + paths.get(i);
                file = new File(sPath = sPath.replace("/", File.separator).replace("\\", File.separator));
                if (!file.exists()) continue;
                return file.getAbsolutePath().replace("/", File.separator).replace("\\", File.separator);
            }
        }
        return "";
    }

    public Vector<String> getValidVegaStrikePaths() {
        Vector<String> paths = this.keys.get(AUTO);
        File file = new File("");
        Vector<String> arrPaths = new Vector<String>();
        if (paths != null) {
            for (int i = 0; i < paths.size(); ++i) {
                String sPath = paths.get(i);
                file = new File(sPath = sPath.replace("/", File.separator).replace("\\", File.separator));
                if (!file.exists() || !this.isValidPath(sPath = file.getAbsolutePath().replace("/", File.separator).replace("\\", File.separator))) continue;
                arrPaths.add(sPath);
            }
        }
        return arrPaths;
    }
}

