/*
 * Decompiled with CFR 0.152.
 */
package vstrade.data.galaxy;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import vstrade.data.Node;
import vstrade.data.bases.Base;
import vstrade.data.bases.Bases;
import vstrade.data.galaxy.Galaxy;
import vstrade.data.galaxy.GalaxyLoadException;
import vstrade.data.galaxy.GalaxySector;
import vstrade.data.galaxy.GalaxySystem;
import vstrade.data.galaxy.Point3D;
import vstrade.io.Log;

public class MilkyWayReader {
    private Galaxy galaxy;
    private Bases bases;

    public boolean load(String filename, Bases bases, Galaxy galaxy) {
        this.bases = bases;
        this.galaxy = galaxy;
        FileInputStream input = null;
        try {
            input = new FileInputStream(new File(filename));
        }
        catch (Exception ex) {
            Log.warning("No galaxy loaded (NOT FOUND: \"" + filename + "\")");
            return false;
        }
        try {
            this.loadGalaxy(input);
        }
        catch (GalaxyLoadException ex) {
            Log.error("No galaxy loaded (PARSER ERROR: \"" + filename + "\"))", ex);
            return false;
        }
        this.resolveJumps();
        Log.info("Galaxy loaded");
        return true;
    }

    private void loadGalaxy(InputStream is) throws GalaxyLoadException {
        DocumentBuilderFactory factory = null;
        DocumentBuilder builder = null;
        Document doc = null;
        try {
            factory = DocumentBuilderFactory.newInstance();
            builder = factory.newDocumentBuilder();
            doc = builder.parse(is);
            is.close();
        }
        catch (Exception e) {
            throw new GalaxyLoadException(e);
        }
        Element element = doc.getDocumentElement();
        this.parseGalaxy(element);
    }

    private void parseGalaxy(Element element) throws GalaxyLoadException {
        if (!element.getNodeName().equals("galaxy")) {
            throw new GalaxyLoadException("Wrong root element name.");
        }
        NodeList planetsElement = element.getElementsByTagName("planets");
        if (planetsElement.getLength() != 1) {
            throw new GalaxyLoadException("Incorrect number of \"planets\"-nodes.");
        }
        NodeList planetList = element.getElementsByTagName("planet");
        for (int i = 0; i < planetList.getLength(); ++i) {
            Element child = (Element)planetList.item(i);
            this.parsePlanet(child);
        }
        NodeList systemList = element.getElementsByTagName("systems");
        if (systemList.getLength() != 1) {
            throw new GalaxyLoadException("Incorrect number of \"systems\"-nodes.");
        }
        Element systemsElement = (Element)systemList.item(0);
        NodeList sectorList = element.getElementsByTagName("sector");
        for (int i = 0; i < sectorList.getLength(); ++i) {
            Element child = (Element)sectorList.item(i);
            this.parseSector(child);
        }
    }

    private void parsePlanet(Element element) {
        Base base;
        String sTrueName = element.getAttribute("name");
        sTrueName = sTrueName.replace("_", " ");
        sTrueName = sTrueName + " (Planets)";
        String sTexture = "";
        NodeList varList = element.getElementsByTagName("var");
        for (int i = 0; i < varList.getLength(); ++i) {
            element = (Element)varList.item(i);
            String sVarName = element.getAttribute("name");
            if (!sVarName.equals("texture")) continue;
            sTexture = element.getAttribute("value");
            sTexture = sTexture.substring(sTexture.indexOf("/") + 1);
            sTexture = sTexture.replace("_", " ");
            sTexture = sTexture.substring(0, 1).toUpperCase() + sTexture.substring(1);
            sTexture = sTexture + " (Planets)";
            break;
        }
        if ((base = (Base)this.bases.getByName(sTexture)) != null) {
            this.bases.remove(base, "Planets");
            base.setName(sTrueName);
            this.bases.add(base);
        }
    }

    private void parseSector(Element element) {
        String name = element.getAttribute("name");
        if (name.equals("") || name.equals("unknown_sector")) {
            return;
        }
        NodeList systemList = element.getElementsByTagName("system");
        if (systemList.getLength() < 1) {
            return;
        }
        GalaxySector sector = new GalaxySector(name);
        for (int i = 0; i < systemList.getLength(); ++i) {
            Element child = (Element)systemList.item(i);
            this.parseSystem(sector, child);
        }
        if (sector.getSize() > 0) {
            this.galaxy.add(sector);
        }
    }

    private void parseSystem(GalaxySector sector, Element element) {
        String name = element.getAttribute("name");
        if ((name = name.replace("_", " ")).equals("")) {
            return;
        }
        String xyz = "";
        String faction = "";
        String jumps = "";
        NodeList varList = element.getElementsByTagName("var");
        for (int i = 0; i < varList.getLength(); ++i) {
            Element child = (Element)varList.item(i);
            String varName = child.getAttribute("name");
            if (varName.equals("xyz")) {
                xyz = child.getAttribute("value");
            }
            if (varName.equals("faction")) {
                faction = child.getAttribute("value");
            }
            if (!varName.equals("jumps")) continue;
            jumps = child.getAttribute("value");
        }
        Point3D pos = this.parsePos(xyz);
        if (pos == null) {
            return;
        }
        if (faction.equals("")) {
            faction = "unknown";
        }
        GalaxySystem system = new GalaxySystem(name, pos, faction);
        if (jumps.length() > 0) {
            String[] parts = jumps.split(" ");
            for (int i = 0; i < parts.length; ++i) {
                system.addJumpString(parts[i]);
            }
        }
        sector.add(system);
    }

    private Point3D parsePos(String pos) {
        String[] parts = pos.split(" ");
        if (parts.length != 3) {
            return null;
        }
        try {
            double x = Double.parseDouble(parts[0]);
            double y = Double.parseDouble(parts[1]);
            double z = Double.parseDouble(parts[2]);
            return new Point3D(x, y, z);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    public void resolveJumps() {
        Vector<Node> galaxyNodes = this.galaxy.getValues();
        for (int a = 0; a < galaxyNodes.size(); ++a) {
            GalaxySector sector = (GalaxySector)galaxyNodes.get(a);
            Vector<Node> sectorNodes = sector.getValues();
            for (int b = 0; b < sectorNodes.size(); ++b) {
                GalaxySystem system = (GalaxySystem)sectorNodes.get(b);
                for (String jumpString : system.getJumpStrings()) {
                    GalaxySystem targetSystem;
                    GalaxySector targetSector;
                    String[] parts = jumpString.split("/");
                    if (parts.length != 2 || (targetSector = (GalaxySector)this.galaxy.getByName(parts[0].replace("_", " "))) == null || (targetSystem = (GalaxySystem)targetSector.getByName(parts[1].replace("_", " "))) == null) continue;
                    system.add(targetSystem);
                }
                system.clearJumpStrings();
            }
        }
    }
}

