/*
 * Decompiled with CFR 0.152.
 */
package vstrade.data.galaxy;

import java.util.Enumeration;
import java.util.List;
import java.util.Vector;
import vstrade.data.Node;
import vstrade.data.galaxy.Point3D;
import vstrade.io.Log;

public class GalaxySystem
extends Node {
    private String sFaction = "";
    private Point3D pos;
    private List<String> jumpStrings;

    public GalaxySystem(String sName, Point3D pos, String sFaction) {
        this.sName = sName;
        this.pos = pos;
        this.sFaction = sFaction;
        this.jumpStrings = new Vector<String>();
    }

    @Override
    public void add(Node n) {
        if (this.nodes.containsKey(n.getName())) {
            Log.warning(n.getName() + " already exist in nodes");
        }
        this.nodes.put(n.getName(), n);
        this.values.add(n);
    }

    public String getFullName() {
        return this.parent.getName() + "/" + this.getName();
    }

    public Point3D getPos() {
        return this.pos;
    }

    public String getFaction() {
        return this.sFaction;
    }

    public List<String> getJumpStrings() {
        return this.jumpStrings;
    }

    public void addJumpString(String jump) {
        this.jumpStrings.add(jump);
    }

    public void clearJumpStrings() {
        this.jumpStrings.clear();
    }

    @Override
    protected void printAdv(int nLevel) {
    }

    @Override
    protected void print(int nLevel, String sPath) {
        String sJumps = "";
        String sJumpsString = "";
        sPath = nLevel != 0 ? sPath + "/" + this.getName() : this.getName();
        Enumeration keys = this.nodes.keys();
        while (keys.hasMoreElements()) {
            sJumps = sJumps + "|" + ((Node)this.nodes.get(keys.nextElement())).getName();
        }
        for (int a = 0; a < this.jumpStrings.size(); ++a) {
            sJumpsString = sJumpsString + this.jumpStrings.get(a);
        }
        System.out.println(sPath + "\t" + sJumps + "\t" + sJumpsString);
    }

    @Override
    public void clear() {
        this.jumpStrings.clear();
        this.nodes.clear();
        this.values.clear();
    }
}

