/*
 * Decompiled with CFR 0.152.
 */
package vstrade.data.galaxy;

import java.util.Vector;
import vstrade.Program;
import vstrade.data.Node;
import vstrade.data.bases.Bases;
import vstrade.data.galaxy.GalaxySector;
import vstrade.data.galaxy.MilkyWayReader;
import vstrade.data.galaxy.Point3D;

public class Galaxy
extends Node {
    private MilkyWayReader milkyWayReader = new MilkyWayReader();
    private boolean isLoaded;
    private Vector<Node> allSystems = new Vector();
    private Point3D min;
    private Point3D max;

    public Galaxy(Program program, Bases bases) {
        this.sName = "galaxy";
        this.isLoaded = this.milkyWayReader.load(program.getSettings().getFileSettings().getMilkyWayPath(), bases, this);
    }

    @Override
    public void add(Node n) {
        super.add(n);
        GalaxySector sector = (GalaxySector)n;
        this.allSystems.addAll(sector.getList());
        Point3D posMin = sector.getMin();
        Point3D posMax = sector.getMax();
        if (this.min == null) {
            this.min = new Point3D(posMin);
            this.max = new Point3D(posMax);
            return;
        }
        if (posMin.x < this.min.x) {
            this.min.x = posMin.x;
        }
        if (posMin.y < this.min.y) {
            this.min.y = posMin.y;
        }
        if (posMin.z < this.min.z) {
            this.min.z = posMin.z;
        }
        if (posMax.x > this.max.x) {
            this.max.x = posMax.x;
        }
        if (posMax.y > this.max.y) {
            this.max.y = posMax.y;
        }
        if (posMax.z > this.max.z) {
            this.max.z = posMax.z;
        }
    }

    public Vector<Node> getSystems() {
        return this.allSystems;
    }

    public boolean isLoaded() {
        return this.isLoaded;
    }

    public Point3D getMin() {
        return this.min;
    }

    public Point3D getMax() {
        return this.max;
    }

    @Override
    public void clear() {
        super.clear();
        this.allSystems.clear();
    }
}

