/*
 * Decompiled with CFR 0.152.
 */
package vstrade.data.bases;

import com.csvreader.CsvReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import vstrade.data.bases.Base;
import vstrade.data.bases.Bases;
import vstrade.data.bases.Category;
import vstrade.io.Log;

public class UnitsParser {
    private final int PATH = 0;
    private final int PRICE_MODIFIER = 1;
    private final int PRICE_FLUCTUATION = 2;
    private final int QUANTITY = 3;
    private final int QUANTITY_FLUCTUATION = 4;
    private boolean bEmptyRows;
    private boolean bMissingCategories;
    private String sMissingCategories;
    private Bases bases = null;
    private Base baseTemplate = null;
    private CsvReader reader;

    public boolean load(String filename, Base baseTemplate, Bases bases) {
        this.baseTemplate = baseTemplate;
        this.bases = bases;
        this.bMissingCategories = false;
        this.sMissingCategories = "";
        try {
            this.reader = new CsvReader(filename);
        }
        catch (FileNotFoundException ex) {
            Log.warning("No bases loaded (NOT FOUND: \"" + filename + "\")");
            return false;
        }
        try {
            this.reader.setSkipEmptyRecords(true);
            this.reader.readHeaders();
            this.reader.readRecord();
            while (this.reader.readRecord()) {
                if (this.reader.get(0).equals("")) continue;
                this.createBase(this.reader.get("Object_Type"), this.reader.get("Combat_Role"), this.reader.get(0), this.reader.get("Cargo_Import"), this.reader.get("Dock"));
            }
        }
        catch (IOException ex) {
            Log.error("No bases loaded (READ FAILED: \"" + filename + "\")", ex);
            return false;
        }
        this.reader.close();
        Log.info("Bases loaded");
        return true;
    }

    private void createBase(String sObjectType, String sCombatRole, String sFile, String sCargo, String sDock) {
        String sBaseName = this.formatBaseName(sFile);
        String sBaseType = this.formatBaseType(sFile);
        if (!(!sObjectType.equals("Installation") && !sCombatRole.equals("BASE") && (!sObjectType.equals("Vessel") || sDock.equals("") || sCargo.equals("")) && !sBaseType.contains("Planet") || sBaseType.contains("Template") || sBaseType.contains("Blank") || sBaseName.contains("Sun") || (sBaseName + " ").contains("star ") || sBaseName.contains("Jump"))) {
            Base base = this.baseTemplate.deepClone();
            if (sObjectType.equals("Vessel")) {
                sBaseName = sBaseType.equals("Standard") ? sBaseName + " (Ships)" : sBaseName + " (Ships " + sBaseType + ")";
                sBaseType = "Ships";
            } else {
                sBaseName = sBaseName + " (" + sBaseType + ")";
            }
            base.setName(sBaseName);
            base.setType(sBaseType);
            this.bases.add(base);
            String[] arrCargo = sCargo.split("\\}\\{");
            arrCargo[arrCargo.length - 1] = arrCargo[arrCargo.length - 1].replace("}", "");
            arrCargo[0] = arrCargo[0].replace("{", "");
            for (int a = 0; a < arrCargo.length; ++a) {
                String sCargoTemp = arrCargo[a];
                String[] items = new String[5];
                for (int b = 0; b < items.length; ++b) {
                    int nEnd = sCargoTemp.indexOf(";");
                    if (nEnd < 0) {
                        nEnd = sCargoTemp.length();
                    }
                    items[b] = sCargoTemp.substring(0, nEnd);
                    if (nEnd < sCargoTemp.length()) {
                        ++nEnd;
                    }
                    sCargoTemp = sCargoTemp.substring(nEnd);
                }
                this.updateCategory(base, items);
            }
        }
    }

    private void updateCategory(Base base, String[] items) {
        String sPath = items[0].replace("_", " ").replace("-", " - ").replace("Agriculteral", "Agricultural");
        Category category = (Category)base.getByPath(sPath);
        if (category == null) {
            if (sPath.equals("")) {
                this.bEmptyRows = true;
            } else {
                String s = "\"" + items[0].replace("_", " ").replace("-", " - ") + "\"";
                int found = this.sMissingCategories.indexOf(s);
                if (found < 0) {
                    if (this.bMissingCategories) {
                        this.sMissingCategories = this.sMissingCategories + ", ";
                    }
                    this.sMissingCategories = this.sMissingCategories + "\"" + items[0].replace("_", " ").replace("-", " - ") + "\"";
                }
                this.bMissingCategories = true;
            }
            return;
        }
        category.setPriceModifier(items[1]);
        category.setPriceFluctuation(items[2]);
        category.setQuantity(items[3]);
        category.setQuantityFluctuation(items[4]);
    }

    private String formatBaseType(String sBaseField) {
        String sBaseType = "";
        if (sBaseField.indexOf(".") >= 0) {
            sBaseType = sBaseField.substring(sBaseField.indexOf(".") + 1);
        }
        if (sBaseField.indexOf("__") >= 0) {
            sBaseType = sBaseField.substring(sBaseField.indexOf("__") + 2);
        }
        if (sBaseField.indexOf("__") < 0 && sBaseField.indexOf(".") < 0) {
            sBaseType = "standard";
        }
        sBaseType = sBaseType.substring(0, 1).toUpperCase() + sBaseType.substring(1);
        while (sBaseType.indexOf("_") > 0) {
            int nStart = sBaseType.indexOf("_");
            sBaseType = sBaseType.substring(0, nStart) + sBaseType.substring(nStart, nStart + 2).toUpperCase().replace("_", " ") + sBaseType.substring(nStart + 2);
        }
        return sBaseType;
    }

    private String formatBaseName(String sBaseField) {
        String sBaseName = "";
        if (sBaseField.indexOf(".") >= 0) {
            sBaseName = sBaseField.substring(0, sBaseField.indexOf("."));
        }
        if (sBaseField.indexOf("__") >= 0) {
            sBaseField = sBaseField.substring(0, sBaseField.indexOf("__"));
        }
        if (sBaseField.indexOf("__") < 0 && sBaseField.indexOf(".") < 0) {
            sBaseName = sBaseField;
        }
        sBaseName = sBaseName.substring(0, 1).toUpperCase() + sBaseName.substring(1);
        sBaseName = sBaseName.replace("_", " ").replace("-", " - ");
        return sBaseName;
    }
}

