/*
 * Decompiled with CFR 0.152.
 */
package vstrade.data.bases;

import com.csvreader.CsvReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import vstrade.data.Node;
import vstrade.data.bases.Base;
import vstrade.data.bases.Cargo;
import vstrade.data.bases.Category;
import vstrade.io.Log;

public class MasterPartListParser {
    private final String CATEGORY_PATH_SEPERATER = "/";
    private Base base = null;
    private Category parent = null;
    private Cargo cargo = null;
    private boolean post043;
    private boolean bEmptyRows;
    private CsvReader reader;

    public boolean load(String filename, Base base) {
        this.base = base;
        try {
            this.reader = new CsvReader(filename);
        }
        catch (FileNotFoundException ex) {
            Log.warning("No cargo loaded (NOT FOUND: \"" + filename + "\")");
            return false;
        }
        catch (NoClassDefFoundError e) {
            if (e.toString().contains("csvreader")) {
                Log.error("The JavaCSV library is missing (lib\\javacsv.jar)\nPlease see vstrade_faq.txt for more information.", e);
            }
            Log.error(e);
        }
        try {
            this.reader.setSkipEmptyRecords(true);
            this.reader.readHeaders();
            this.post043 = true;
            while (this.reader.readRecord()) {
                if (this.reader.get("categoryname").equals("") || this.reader.get("file").equals("") || this.reader.get("price").equals("") || this.reader.get("description").equals("") || this.reader.get("volume").equals("") || this.reader.get("file").contains("DummySentinel")) continue;
                this.addCategories(this.reader.get("categoryname"));
                this.addCargo(this.reader.get("file"), this.reader.get("price"), this.reader.get("description"), this.reader.get("volume"));
            }
        }
        catch (IOException ex) {
            Log.error("No cargo loaded (READ FAILED: \"" + filename + "\")", ex);
            return false;
        }
        this.reader.close();
        Log.info("Cargo loaded");
        return true;
    }

    private void addCategories(String sPath) {
        int a;
        sPath = sPath.replace("_", " ").replace("-", " - ");
        String[] arrNames = sPath.split("/");
        String[] arrPath = sPath.split("/");
        for (a = 1; a < arrPath.length; ++a) {
            arrPath[a] = arrPath[a - 1] + "/" + arrPath[a];
        }
        for (a = 0; a < arrPath.length; ++a) {
            Node found = this.base.getByPath(arrPath[a]);
            this.parent = found != null ? (Category)found : (a == 0 ? new Category(arrNames[a], this.base, this.post043) : new Category(arrNames[a], this.parent, this.post043));
        }
    }

    private void addCargo(String sName, String sPrice, String sDescription, String sCargoSpace) {
        this.cargo = new Cargo(sName.replace("_", " ").replace("-", " - "), this.parent);
        if (!sPrice.equals("")) {
            this.cargo.setStandardPrice(sPrice);
        }
        if (!sCargoSpace.equals("")) {
            this.cargo.setCargoVolume(sCargoSpace);
        }
        if (sDescription.length() > 0 && sDescription.indexOf("@") == 0) {
            this.cargo.setDescription(sDescription.substring(sDescription.lastIndexOf("@") + 1));
            this.cargo.setImagePath(sDescription.substring(sDescription.indexOf("@") + 1, sDescription.lastIndexOf("@")).replace("/", File.separator));
        } else {
            this.cargo.setDescription(sDescription);
            this.cargo.setImagePath("cargo" + File.separator + "cargo_hud.png");
        }
    }
}

