/*
 * Decompiled with CFR 0.152.
 */
package vstrade.data.bases;

import java.util.Enumeration;
import java.util.Vector;
import vstrade.data.Node;
import vstrade.data.bases.Cargo;
import vstrade.io.Log;

public class Category
extends Node {
    private float nQuantity = 0.0f;
    private float nQuantityFluctuation = 0.0f;
    private float nPriceFluctuation = 0.0f;
    private float nPriceModifier = 0.0f;

    public Category(String sName) {
        this.sName = sName;
    }

    public Category(String sName, Node parent, boolean svnVersion) {
        this.sName = sName;
        this.parent = parent;
        if (svnVersion) {
            this.nPriceModifier = 1.0f;
        }
        parent.add(this);
    }

    public void setQuantity(String sQuantity) {
        float n;
        if (sQuantity.equals("")) {
            return;
        }
        try {
            n = Float.valueOf(sQuantity).floatValue();
        }
        catch (NumberFormatException ex) {
            Log.warning(this.getClass() + ".setQuantity() :: NaN error (Attempt to convert String  \"sQuantity@" + sQuantity + "\" to Float failed)");
            return;
        }
        this.setQuantity(n);
    }

    public void setQuantity(float nQuantity) {
        this.nQuantity = nQuantity;
    }

    public void setQuantityFluctuation(String sQuantityFluctuation) {
        float n;
        if (sQuantityFluctuation.equals("")) {
            return;
        }
        try {
            n = Float.valueOf(sQuantityFluctuation).floatValue();
        }
        catch (NumberFormatException ex) {
            Log.warning(this.getClass() + ".setQuantityFluctuation() :: NaN error (Attempt to convert String \"sQuantityFluctuation@" + sQuantityFluctuation + "\" to Float failed)");
            return;
        }
        this.setQuantityFluctuation(n);
    }

    public void setQuantityFluctuation(float nQuantityFluctuation) {
        this.nQuantityFluctuation = nQuantityFluctuation;
    }

    public void setPriceFluctuation(String sPriceFluctuation) {
        float n;
        if (sPriceFluctuation.equals("")) {
            return;
        }
        try {
            n = Float.valueOf(sPriceFluctuation).floatValue();
        }
        catch (NumberFormatException ex) {
            Log.warning(this.getClass() + ".setPriceFluctuation() :: NaN error (Attempt to convert String \"sPriceFluctuation@" + sPriceFluctuation + "\" to Float failed)");
            return;
        }
        this.setPriceFluctuation(n);
    }

    public void setPriceFluctuation(float nPriceFluctuation) {
        this.nPriceFluctuation = nPriceFluctuation;
    }

    public void setPriceModifier(String PriceModifier) {
        float n;
        if (PriceModifier.equals("")) {
            return;
        }
        try {
            n = Float.valueOf(PriceModifier).floatValue();
        }
        catch (NumberFormatException ex) {
            Log.warning(this.getClass() + ".setPriceModifier() :: NaN error (Attempt to convert String \"PriceModifier@" + PriceModifier + "\" to Float failed)");
            return;
        }
        this.setPriceModifier(n);
    }

    public void setPriceModifier(float nPriceModifier) {
        this.nPriceModifier = nPriceModifier;
    }

    public float getQuantity() {
        return this.nQuantity;
    }

    public float getQuantityFluctuation() {
        return this.nQuantityFluctuation;
    }

    public float getPriceFluctuation() {
        return this.nPriceFluctuation;
    }

    public float getPriceModifier() {
        return this.nPriceModifier;
    }

    public Category deepClone() {
        Category copy = new Category(this.getName());
        copy.setPriceFluctuation(this.getPriceFluctuation());
        copy.setPriceModifier(this.getPriceModifier());
        copy.setQuantity(this.getQuantity());
        copy.setQuantityFluctuation(this.getQuantityFluctuation());
        Enumeration keys = this.nodes.keys();
        while (keys.hasMoreElements()) {
            Node child;
            String key = (String)keys.nextElement();
            if (((Node)this.nodes.get(key)).getClass().equals(Cargo.class)) {
                child = ((Cargo)this.nodes.get(key)).deepClone();
                copy.add(child);
                continue;
            }
            child = ((Category)this.nodes.get(key)).deepClone();
            copy.add(child);
        }
        return copy;
    }

    @Override
    public String toString() {
        Vector<Node> vectorNode = this.getParents();
        String sSpace = "";
        for (int a = 2; a < vectorNode.size(); ++a) {
            sSpace = sSpace + "  ";
        }
        return sSpace + this.getName();
    }
}

