/*
 * Decompiled with CFR 0.152.
 */
package vstrade.data.bases;

import java.util.Vector;
import vstrade.data.Node;
import vstrade.data.bases.Category;
import vstrade.io.Log;

public class Cargo
extends Node {
    private String sDescription = "";
    private String sImageURL = "";
    private float nStandardPrice = 0.0f;
    private float nCargoVolume = 1.0f;

    public Cargo(String sName) {
        this.sName = sName;
    }

    public Cargo(String sName, Node parent) {
        this.sName = sName;
        this.parent = parent;
        parent.add(this);
    }

    public String getDescription() {
        return this.sDescription;
    }

    public void setDescription(String sDescription) {
        this.sDescription = sDescription;
    }

    public String getImagePath() {
        return this.sImageURL;
    }

    public void setImagePath(String sImageURL) {
        this.sImageURL = sImageURL;
    }

    public void setStandardPrice(String sStandardPrice) {
        float n;
        try {
            n = Float.valueOf(sStandardPrice).floatValue();
        }
        catch (NumberFormatException ex) {
            Log.warning(this.getClass() + ".setStandardPrice() :: NaN error (Attempt to convert String \"sStandardPrice@" + sStandardPrice + "\" to Float failed)");
            return;
        }
        this.setStandardPrice(n);
    }

    public void setStandardPrice(float n) {
        this.nStandardPrice = n;
    }

    public int getQuantityMaximum() {
        Category parentCategory = (Category)this.getParent();
        if (parentCategory == null) {
            Log.error(this.getClass() + ".getQuantityMaximum() :: No Parent");
            return 0;
        }
        int nQuantityMaximume = (int)(parentCategory.getQuantity() + parentCategory.getQuantityFluctuation());
        if (nQuantityMaximume < 0) {
            nQuantityMaximume = 0;
        }
        return nQuantityMaximume;
    }

    public int getQuantityAverage() {
        Category parentCategory = (Category)this.getParent();
        if (parentCategory == null) {
            Log.error(this.getClass() + ".getQuantityAverage() :: No Parent");
            return 0;
        }
        int nQuantityAverage = (int)parentCategory.getQuantity();
        if (nQuantityAverage < 0) {
            nQuantityAverage = 0;
        }
        return nQuantityAverage;
    }

    public int getQuantityMinimum() {
        Category parentCategory = (Category)this.getParent();
        if (parentCategory == null) {
            Log.error(this.getClass() + ".getQuantityMinimum() :: No Parent");
            return 0;
        }
        int nQuantityMinimum = (int)(parentCategory.getQuantity() - parentCategory.getQuantityFluctuation());
        if (nQuantityMinimum < 0) {
            nQuantityMinimum = 0;
        }
        return nQuantityMinimum;
    }

    public int getPriceMaximum() {
        Category parentCategory = (Category)this.getParent();
        if (parentCategory == null) {
            Log.error(this.getClass() + ".getPriceMaximum() :: No Parent");
            return 0;
        }
        return (int)(parentCategory.getPriceModifier() * this.nStandardPrice + parentCategory.getPriceFluctuation() * this.nStandardPrice);
    }

    public int getPriceAverage() {
        Category parentCategory = (Category)this.getParent();
        if (parentCategory == null) {
            Log.error(this.getClass() + ".getPriceAverage() :: No Parent");
            return 0;
        }
        return (int)(parentCategory.getPriceModifier() * this.nStandardPrice);
    }

    public int getPriceMinimum() {
        Category parentCategory = (Category)this.getParent();
        if (parentCategory == null) {
            Log.error(this.getClass() + ".getPriceMinimum() :: No Parent");
            return 0;
        }
        return (int)(parentCategory.getPriceModifier() * this.nStandardPrice - parentCategory.getPriceFluctuation() * this.nStandardPrice);
    }

    public int getPricePercent() {
        Category parentCategory = (Category)this.getParent();
        if (parentCategory == null) {
            Log.error(this.getClass() + ".getPricePercent() :: No Parent");
            return 0;
        }
        return (int)(parentCategory.getPriceModifier() * 100.0f);
    }

    public float getStandardPrice() {
        return this.nStandardPrice;
    }

    public Cargo deepClone() {
        Cargo copy = new Cargo(this.getName());
        copy.setStandardPrice(this.getStandardPrice());
        copy.setDescription(this.getDescription());
        copy.setImagePath(this.getImagePath());
        copy.setCargoVolume(this.getCargoVolume());
        return copy;
    }

    public static int calcPercentProfitMax(Cargo buy, Cargo sell, boolean bUpgrade) {
        float nBuy = buy.getPriceMinimum();
        float nSell = sell.getPriceMaximum();
        return Cargo.calcPercent(nBuy, nSell, bUpgrade);
    }

    public static int calcPercentProfitAvg(Cargo buy, Cargo sell, boolean bUpgrade) {
        float nBuy = buy.getPriceAverage();
        float nSell = sell.getPriceAverage();
        return Cargo.calcPercent(nBuy, nSell, bUpgrade);
    }

    public static int calcPercentProfitMin(Cargo buy, Cargo sell, boolean bUpgrade) {
        float nBuy = buy.getPriceMaximum();
        float nSell = sell.getPriceMinimum();
        return Cargo.calcPercent(nBuy, nSell, bUpgrade);
    }

    public static int calcCashProfitMax(Cargo buy, Cargo sell, boolean bUpgrade) {
        if (bUpgrade) {
            return sell.getPriceMaximum() / 2 - buy.getPriceMinimum();
        }
        return sell.getPriceMaximum() - buy.getPriceMinimum();
    }

    public static int calcCashProfitAvg(Cargo buy, Cargo sell, boolean bUpgrade) {
        if (bUpgrade) {
            return sell.getPriceAverage() / 2 - buy.getPriceAverage();
        }
        return sell.getPriceAverage() - buy.getPriceAverage();
    }

    public static int calcCashProfitMin(Cargo buy, Cargo sell, boolean bUpgrade) {
        if (bUpgrade) {
            return sell.getPriceMinimum() / 2 - buy.getPriceMaximum();
        }
        return sell.getPriceMinimum() - buy.getPriceMaximum();
    }

    @Override
    public String toString() {
        Vector<Node> vectorNode = this.getParents();
        String sSpace = "";
        for (int a = 1; a < vectorNode.size(); ++a) {
            sSpace = sSpace + "  ";
        }
        return sSpace + this.getName();
    }

    private static int calcPercent(float nBuy, float nSell, boolean bUpgrade) {
        if (nBuy > 0.0f && nSell > 0.0f) {
            if (bUpgrade) {
                int result = (int)(nSell / 2.0f / nBuy * 100.0f) - 100;
                if (result > 0) {
                    return result;
                }
            } else {
                int result = (int)(nSell / nBuy * 100.0f) - 100;
                if (result > 0) {
                    return result;
                }
            }
        }
        return 0;
    }

    public float getCargoVolume() {
        return this.nCargoVolume;
    }

    public void setCargoVolume(float nCargoVolume) {
        this.nCargoVolume = nCargoVolume;
    }

    public void setCargoVolume(String nCargoVolume) {
        float n;
        try {
            n = Float.valueOf(nCargoVolume).floatValue();
        }
        catch (NumberFormatException ex) {
            Log.warning(this.getClass() + ".setCargoSpace() :: NaN error (Attempt to convert String \"sCargoSpace@" + nCargoVolume + "\" to Integer failed)");
            return;
        }
        this.setCargoVolume(n);
    }
}

