/*
 * Decompiled with CFR 0.152.
 */
package vstrade.data.bases;

import java.util.Collections;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import vstrade.Program;
import vstrade.data.Node;
import vstrade.data.bases.Base;
import vstrade.data.bases.MasterPartListParser;
import vstrade.data.bases.UnitsParser;

public class Bases
extends Node {
    private Vector<String> typeList;
    private Vector<Node> cargoList = null;
    private Hashtable<String, Hashtable<String, Node>> basesByTypeNodeLists;
    private Base templateBase;
    private MasterPartListParser masterPartListParser;
    private UnitsParser unitsParser;
    private boolean isLoaded;

    public Bases(String sName, Base templateBase) {
        this.sName = sName;
        this.templateBase = templateBase;
        this.typeList = new Vector();
        this.basesByTypeNodeLists = new Hashtable();
        this.cargoList = new Vector();
    }

    public Bases(Program program) {
        this.sName = "Bases";
        this.typeList = new Vector();
        this.basesByTypeNodeLists = new Hashtable();
        this.cargoList = new Vector();
        this.templateBase = new Base("", "");
        this.masterPartListParser = new MasterPartListParser();
        this.unitsParser = new UnitsParser();
        this.isLoaded = this.masterPartListParser.load(program.getSettings().getFileSettings().getMasterPartListPath(), this.templateBase);
        this.createCargoList(this.templateBase);
        this.isLoaded = this.unitsParser.load(program.getSettings().getFileSettings().getUnitsPath(), this.templateBase, this);
    }

    public void add(Base n) {
        super.add(n);
        if (!this.typeList.contains(n.getType())) {
            this.typeList.add(n.getType());
            this.basesByTypeNodeLists.put(n.getType(), new Hashtable());
        }
        this.basesByTypeNodeLists.get(n.getType()).put(n.getName(), n);
    }

    public Bases deepClone() {
        Bases copy = new Bases(this.sName, this.templateBase);
        Enumeration keys = this.nodes.keys();
        while (keys.hasMoreElements()) {
            Base child = ((Base)this.nodes.get(keys.nextElement())).deepClone();
            copy.add(child);
        }
        return copy;
    }

    public Vector<String> getTypeList() {
        Vector<String> vector = new Vector<String>(this.typeList);
        Collections.sort(vector);
        return vector;
    }

    public Vector<Node> getBaseList() {
        Vector<Node> vector = new Vector<Node>(this.getValues());
        Collections.sort(vector);
        return vector;
    }

    public Vector<Node> getBaseList(String key) {
        Vector<Node> vector = new Vector<Node>(this.basesByTypeNodeLists.get(key).values());
        Collections.sort(vector);
        return vector;
    }

    public Base getTemplateBase() {
        return this.templateBase;
    }

    public Vector<Node> getCargoList() {
        return new Vector<Node>(this.cargoList);
    }

    public void remove(Node n, String key) {
        this.nodes.remove(n.getName());
        this.values.remove(n);
        Hashtable<String, Node> keyHashtable = this.basesByTypeNodeLists.get(key);
        if (keyHashtable.size() == 1) {
            this.typeList.remove(key);
            this.basesByTypeNodeLists.remove(key);
        }
        keyHashtable.remove(n.getName());
    }

    private void createCargoList(Node node) {
        Vector<Node> cargovalues = node.getValues();
        for (int a = 0; a < cargovalues.size(); ++a) {
            Node child = cargovalues.get(a);
            if (child == null) continue;
            this.cargoList.add(child);
            this.createCargoList(child);
        }
    }

    public boolean isLoaded() {
        return this.isLoaded;
    }

    @Override
    public void clear() {
        super.clear();
        System.out.println("Clearing...");
        this.cargoList.clear();
        this.typeList.clear();
        Enumeration<String> keys = this.basesByTypeNodeLists.keys();
        while (keys.hasMoreElements()) {
            this.basesByTypeNodeLists.get(keys.nextElement()).clear();
        }
        this.basesByTypeNodeLists.clear();
        this.templateBase.clear();
        this.cargoList = null;
        this.typeList = null;
        this.basesByTypeNodeLists = null;
        this.templateBase = null;
    }
}

