/*
 * Decompiled with CFR 0.152.
 */
package vstrade.data;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import vstrade.data.bases.Base;
import vstrade.data.bases.Cargo;
import vstrade.io.Log;

public class Node
implements Comparable<Node> {
    protected Hashtable<String, Node> nodes = null;
    protected Vector<Node> values;
    protected Node parent;
    protected String sName = "";

    public Node(String sName) {
        this.sName = sName;
        this.nodes = new Hashtable();
        this.values = new Vector();
    }

    public Node() {
        this.nodes = new Hashtable();
        this.values = new Vector();
    }

    public String getName() {
        return this.sName;
    }

    public void setName(String sName) {
        this.sName = sName;
    }

    protected void setParent(Node parent) {
        this.parent = parent;
    }

    public Node getParent() {
        return this.parent;
    }

    public void add(Node n) {
        n.setParent(this);
        if (this.nodes.containsKey(n.getName())) {
            Log.warning(n.getName() + " already exist in nodes");
        }
        this.nodes.put(n.getName(), n);
        this.values.add(n);
    }

    public int getSize() {
        return this.nodes.size();
    }

    public Vector<Node> getValues() {
        return this.values;
    }

    public Node getByName(String s) {
        return this.nodes.get(s);
    }

    public Node getByPath(String path) {
        Node node = this;
        String[] arrPath = path.split("/");
        int a = 0;
        if (arrPath[0].equals(this.getName())) {
            ++a;
        }
        for (int i = a; i < arrPath.length && node != null; node = node.getByName(arrPath[i]), ++i) {
        }
        return node;
    }

    public Node getRoot() {
        Vector<Node> parents = this.getParents();
        return parents.get(0);
    }

    public String getPath() {
        String sPath = this.getName();
        Node node = this;
        while (node.getParent() != null) {
            if (node.getParent() instanceof Base) {
                return sPath;
            }
            if ((node = node.getParent()).getName().equals("")) continue;
            sPath = node.getName() + "/" + sPath;
        }
        return sPath;
    }

    public Vector<Node> getParents() {
        Vector<Node> parents = new Vector<Node>();
        parents.add(this);
        Node temp = this;
        while (temp.getParent() != null) {
            parents.add(0, temp.getParent());
            temp = temp.getParent();
        }
        return parents;
    }

    public boolean equals(Node n) {
        return n.getName().equals(this.getName()) && n.getPath().equals(this.getPath());
    }

    public int hashCode() {
        return this.getName().hashCode();
    }

    public boolean equals(Object o) {
        if (o instanceof Node) {
            return this.equals((Node)o);
        }
        return false;
    }

    public void printAdv() {
        this.printAdv(0);
    }

    protected void printAdv(int nLevel) {
        String sSpace = "";
        for (int a = 0; a < nLevel; ++a) {
            sSpace = sSpace + "\t";
        }
        String sOutput = "";
        if (this.getClass().equals(Cargo.class)) {
            sOutput = "  MaxP: " + ((Cargo)this).getPriceMaximum() + " AvgP: " + ((Cargo)this).getPriceAverage() + " MinP: " + ((Cargo)this).getPriceMinimum() + " MaxQ: " + ((Cargo)this).getQuantityMaximum() + " AvgQ: " + ((Cargo)this).getQuantityAverage() + " MinQ: " + ((Cargo)this).getQuantityMinimum();
        }
        System.out.println(sSpace + this.getName() + sOutput);
        Enumeration<String> keys = this.nodes.keys();
        while (keys.hasMoreElements()) {
            this.nodes.get(keys.nextElement()).printAdv(nLevel + 1);
        }
    }

    public void print() {
        this.print(0, "");
    }

    protected void print(int nLevel, String sPath) {
        sPath = nLevel != 0 ? sPath + "/" + this.getName() : this.getName();
        Enumeration<String> keys = this.nodes.keys();
        while (keys.hasMoreElements()) {
            this.nodes.get(keys.nextElement()).print(nLevel + 1, sPath);
        }
        if (this.getClass().equals(Cargo.class)) {
            System.out.println(sPath);
        }
    }

    @Override
    public int compareTo(Node o) {
        return this.getName().compareTo(o.getName());
    }

    public String toString() {
        return this.sName;
    }

    public void clear() {
        Enumeration<String> keys = this.nodes.keys();
        while (keys.hasMoreElements()) {
            this.nodes.get(keys.nextElement()).clear();
        }
        this.nodes.clear();
        this.values.clear();
        this.nodes = null;
        this.values = null;
    }
}

