/*
 * Decompiled with CFR 0.152.
 */
package vstrade;

import ca.odell.glazedlists.swing.EventTableModel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Vector;
import javax.swing.JOptionPane;
import javax.swing.JTable;
import vstrade.SplashUpdater;
import vstrade.data.bases.Base;
import vstrade.data.bases.Bases;
import vstrade.data.bases.Cargo;
import vstrade.data.galaxy.Galaxy;
import vstrade.data.settings.Settings;
import vstrade.io.DataCreater;
import vstrade.io.DataSaver;
import vstrade.io.Log;
import vstrade.io.VsTradeUncaughtExceptionHandler;
import vstrade.moduls.about.AboutView;
import vstrade.moduls.cargo.CargoView;
import vstrade.moduls.frame.TabFrame;
import vstrade.moduls.help.HelpView;
import vstrade.moduls.map.MapView;
import vstrade.moduls.price.PriceTableRow;
import vstrade.moduls.price.PriceView;
import vstrade.moduls.settings.SettingsView;
import vstrade.moduls.status.StatusView;
import vstrade.moduls.trade.TradeTableRow;
import vstrade.moduls.trade.TradeView;

public class Program
implements ActionListener,
MouseListener {
    public static final String ACTION_TRADE_PRICE_ADD_BUY_BASE = "TradePriceAddBuyBase";
    public static final String ACTION_TRADE_PRICE_ADD_SELL_BASE = "TradePriceAddSellBase";
    public static final String ACTION_TRADE_PRICE_SET_CARGO = "TradePriceSetCargo";
    public static final String ACTION_TRADE_CARGO_SET_CARGO = "TradeCargoSetCargo";
    public static final String ACTION_PRICE_TRADE_ADD_AS_BUY_BASE = "PriceTradeAddAsBuyBase";
    public static final String ACTION_PRICE_TRADE_ADD_AS_SELL_BASE = "PriceTradeAssAsSellBase";
    public static final String ACTION_PRICE_CARGO_SET_CARGO = "PriceCargoSetCargo";
    private StatusView statusView;
    private TabFrame tabFrame;
    private TradeView tradeView;
    private PriceView priceView;
    private CargoView cargoView;
    private MapView mapView;
    private SettingsView settingsView;
    private AboutView aboutView;
    private HelpView helpView;
    private Settings settings = null;
    private Galaxy galaxy;
    private Bases bases;

    public Program() {
        String s;
        Vector<String> sVsPaths;
        System.setProperty("sun.awt.exception.handler", "vstrade.io.VsTradeUncaughtExceptionHandler");
        Thread.setDefaultUncaughtExceptionHandler(new VsTradeUncaughtExceptionHandler());
        Log.info("Starting VSTrade 0.3.0.0");
        this.settings = new Settings();
        if (!this.settings.getFileSettings().isVegaStrikePathVaild() && this.settings.getAutoConfig() && (sVsPaths = this.settings.getFileSettings().getValidVegaStrikePaths()).size() > 0 && (s = (String)JOptionPane.showInputDialog(null, this.settings.getLanguageSettings().getString("SelectVSDir", "program"), this.settings.getLanguageSettings().getString("VSTradeConfig", "program"), -1, null, sVsPaths.toArray(), sVsPaths.get(0))) != null) {
            this.settings.getFileSettings().setVegaStrikePath(s);
            this.settings.saveSettings();
        }
        SplashUpdater.setProgress(10);
        SplashUpdater.setText(this.settings.getLanguageSettings().getString("LoadingGUI", "program"));
        this.tabFrame = new TabFrame();
        this.statusView = new StatusView(this);
        this.tabFrame.setStatusbar(this.statusView);
        SplashUpdater.setProgress(15);
        try {
            this.tradeView = new TradeView(this);
        }
        catch (NoClassDefFoundError e) {
            if (e.toString().contains("glazedlists")) {
                Log.error("The Glazed Lists library is missing (lib\\glazedlists-1.7.0_java15.jar)\nPlease see vstrade_faq.txt for more information.", e);
            }
            Log.error(e);
        }
        this.tabFrame.addTab(this.tradeView);
        SplashUpdater.setProgress(20);
        this.priceView = new PriceView(this);
        this.tabFrame.addTab(this.priceView);
        SplashUpdater.setProgress(25);
        this.cargoView = new CargoView(this);
        this.tabFrame.addTab(this.cargoView);
        SplashUpdater.setProgress(30);
        this.mapView = new MapView(this);
        this.tabFrame.addTab(this.mapView);
        SplashUpdater.setProgress(35);
        this.settingsView = new SettingsView(this);
        this.tabFrame.addTab(this.settingsView);
        SplashUpdater.setProgress(45);
        this.aboutView = new AboutView(this);
        this.tabFrame.addTab(this.aboutView);
        SplashUpdater.setProgress(50);
        Log.info("GUI loaded");
        SplashUpdater.setText(this.settings.getLanguageSettings().getString("LoadingData", "program"));
        this.clearData();
        DataCreater dataCreater = new DataCreater(this);
        dataCreater.run();
    }

    public void setGalaxy(Galaxy galaxy) {
        this.galaxy = galaxy;
    }

    public void setBases(Bases bases) {
        this.bases = bases;
    }

    public Bases getBases() {
        return this.bases;
    }

    public Galaxy getGalaxy() {
        return this.galaxy;
    }

    public Settings getSettings() {
        return this.settings;
    }

    public StatusView getStatusView() {
        return this.statusView;
    }

    public void load() {
        this.clearData();
        DataCreater dataCreater = new DataCreater(this);
        dataCreater.start();
    }

    public void save() {
        DataSaver dataSaver = new DataSaver(this, this.settings.getFileSettings().isVegaStrikePathUpdated());
        dataSaver.start();
    }

    public void setData() {
        this.statusView.setData();
        this.mapView.setData();
        this.priceView.setData();
        this.tradeView.setData();
        this.cargoView.setData();
        this.settingsView.setData();
        this.aboutView.setData();
        this.tabFrame.setData();
        this.tabFrame.show();
        System.gc();
    }

    public void clearData() {
        if (this.bases != null) {
            this.bases.clear();
            this.bases = null;
        }
        if (this.galaxy != null) {
            this.galaxy.clear();
            this.galaxy = null;
        }
        this.statusView.clearData();
        this.mapView.clearData();
        this.priceView.clearData();
        this.tradeView.clearData();
        this.cargoView.clearData();
        this.settingsView.clearData();
        this.aboutView.clearData();
        this.tabFrame.clearData();
        System.gc();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Cargo cargo;
        Base base;
        if (ACTION_TRADE_PRICE_ADD_BUY_BASE.equals(e.getActionCommand())) {
            base = this.tradeView.getSelectedBuyBase();
            if (base == null) {
                return;
            }
            this.priceView.addBase(base);
            if (this.settings.getSwitchComponent()) {
                this.tabFrame.setSelectedComponent(this.priceView);
            }
        }
        if (ACTION_TRADE_PRICE_ADD_SELL_BASE.equals(e.getActionCommand())) {
            base = this.tradeView.getSelectedSellBase();
            if (base == null) {
                return;
            }
            this.priceView.addBase(base);
            if (this.settings.getSwitchComponent()) {
                this.tabFrame.setSelectedComponent(this.priceView);
            }
        }
        if (ACTION_TRADE_PRICE_SET_CARGO.equals(e.getActionCommand())) {
            cargo = this.tradeView.getSelectedCargo();
            if (cargo == null) {
                return;
            }
            this.priceView.setSelectedCargo(cargo);
            if (this.settings.getSwitchComponent()) {
                this.tabFrame.setSelectedComponent(this.priceView);
            }
        }
        if (ACTION_TRADE_CARGO_SET_CARGO.equals(e.getActionCommand())) {
            cargo = this.tradeView.getSelectedCargo();
            if (cargo == null) {
                return;
            }
            this.cargoView.setSelectedCargo(cargo);
            if (this.settings.getSwitchComponent()) {
                this.tabFrame.setSelectedComponent(this.cargoView);
            }
        }
        if (ACTION_PRICE_TRADE_ADD_AS_BUY_BASE.equals(e.getActionCommand())) {
            base = this.priceView.getSelectedBase();
            if (base == null) {
                return;
            }
            this.tradeView.addBuyBase(base);
            if (this.settings.getSwitchComponent()) {
                this.tabFrame.setSelectedComponent(this.tradeView);
            }
        }
        if (ACTION_PRICE_TRADE_ADD_AS_SELL_BASE.equals(e.getActionCommand())) {
            base = this.priceView.getSelectedBase();
            if (base == null) {
                return;
            }
            this.tradeView.addSellBase(base);
            if (this.settings.getSwitchComponent()) {
                this.tabFrame.setSelectedComponent(this.tradeView);
            }
        }
        if (ACTION_PRICE_CARGO_SET_CARGO.equals(e.getActionCommand())) {
            cargo = this.priceView.getSelectedCargo();
            if (cargo == null) {
                return;
            }
            this.cargoView.setSelectedCargo(cargo);
            if (this.settings.getSwitchComponent()) {
                this.tabFrame.setSelectedComponent(this.cargoView);
            }
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        Object o;
        if (e.getClickCount() == 2 && e.getButton() == 1 && (o = e.getSource()) instanceof JTable) {
            JTable jTable = (JTable)o;
            int row = jTable.getSelectedRow();
            if (row < 0) {
                return;
            }
            EventTableModel jTableModel = (EventTableModel)jTable.getModel();
            o = jTableModel.getElementAt(row);
            Cargo cargo = null;
            if (o instanceof TradeTableRow) {
                TradeTableRow tradeTableRow = (TradeTableRow)o;
                cargo = tradeTableRow.getCargo();
            }
            if (o instanceof PriceTableRow) {
                PriceTableRow priceTableRow = (PriceTableRow)o;
                cargo = priceTableRow.getCargo();
            }
            if (cargo != null) {
                this.cargoView.setSelectedCargo(cargo);
                this.tabFrame.setSelectedComponent(this.cargoView);
            }
        }
    }
}

